#!/bin/sh

echo "delete....."
rm *.key *.pem *.srl *.csr  server/* client/*
#sleep 1s
echo "1.general ca.key ca.pem"

openssl genrsa -out ca.key 2048

openssl req -x509 -new -nodes -key ca.key -sha256 -days 36500 -subj "/CN=www.emqx.io" -out ca.pem


echo "2. general server.key server.csr server."
openssl genrsa -out server.key 2048

#openssl req -new -key ./server.key -out server.csr -subj "/CN=127.0.0.1"
openssl req -new -key ./server.key -out server.csr -subj "/CN=47.104.172.169"

openssl x509 -req -in ./server.csr -CA ca.pem -CAkey ca.key -CAcreateserial -out server.pem -days 36500 -sha256


echo "3. general client key and cert"
openssl genrsa -out client.key 2048


#openssl req -new -key ./client.key -out client.csr -subj "/CN=127.0.0.1"
openssl req -new -key ./client.key -out client.csr -subj "/CN=47.104.172.169"

openssl x509 -req -in ./client.csr -CA ca.pem -CAkey ca.key -CAcreateserial -out client.pem -days 36500 -sha256



cp server.key server/key.pem
cp server.pem server/cert.pem
cp ca.pem server/cacert.pem

rm ../etc/certs/*
cp server/* ../etc/certs/

rm ../etc/certs/*
cp server/* ../etc/certs/

cp client.key client/client_private.pem
cp client.pem client/client_ca.pem
cp ca.pem client/rootca.pem





rm *.key *.pem *.srl *.csr 
